/*
 * Decompiled with CFR 0.152.
 */
package moyumc;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class AdvancedTNTHandler
extends JavaPlugin
implements Listener {
    private static final int FUSE_TICKS = 80;
    private static final double THROW_SPEED = 1.5;
    private static final double UPWARD_FORCE = 0.5;

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("\u00a76[AdvancedTNT] \u00a7a\u63d2\u4ef6\u5df2\u542f\u7528 - JiaChenFang\u5236\u4f5c\u300c\u6478\u9c7c\u52a8\u529b\u670d\u52a1\u5668\u8150\u7af9\u300d");
    }

    public void onDisable() {
        this.getLogger().info("\u00a76[AdvancedTNT] \u00a7c\u63d2\u4ef6\u5df2\u7981\u7528");
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() == Material.TNT && event.getAction().toString().contains("RIGHT_CLICK")) {
            Block targetBlock = player.getTargetBlockExact(5);
            if (targetBlock == null) {
                event.setCancelled(true);
                this.removeOneTNT(player);
                this.throwTNT(player);
            } else {
                BlockFace face = event.getBlockFace();
                if (this.isPlaceableSurface(targetBlock, face)) {
                    event.setCancelled(true);
                    this.removeOneTNT(player);
                    this.placeAndIgniteTNT(player, targetBlock, face);
                } else {
                    event.setCancelled(true);
                    this.removeOneTNT(player);
                    this.throwTNT(player);
                }
            }
        }
    }

    private boolean isPlaceableSurface(Block block, BlockFace face) {
        if (face == BlockFace.UP) {
            return true;
        }
        Material type = block.getType();
        boolean isFullCube = type.isSolid() && !type.toString().contains("STAIRS") && !type.toString().contains("SLAB") && !type.toString().contains("FENCE") && !type.toString().contains("WALL") && !type.toString().contains("GLASS_PANE") && !type.toString().contains("DOOR") && !type.toString().contains("GATE") && !type.toString().contains("BUTTON") && !type.toString().contains("TRAPDOOR") && !type.toString().contains("LEVER");
        return (face == BlockFace.NORTH || face == BlockFace.SOUTH || face == BlockFace.EAST || face == BlockFace.WEST) && isFullCube;
    }

    private void placeAndIgniteTNT(Player player, Block targetBlock, BlockFace face) {
        Location placeLocation = targetBlock.getRelative(face).getLocation();
        placeLocation.add(0.5, 0.0, 0.5);
        if (face == BlockFace.DOWN) {
            placeLocation.add(0.0, 1.0, 0.0);
        }
        TNTPrimed tnt = (TNTPrimed)player.getWorld().spawn(placeLocation, TNTPrimed.class);
        tnt.setFuseTicks(80);
        tnt.setSource((Entity)player);
        player.getWorld().playSound(placeLocation, Sound.ENTITY_TNT_PRIMED, 1.0f, 1.0f);
        player.getWorld().spawnParticle(Particle.SMOKE_LARGE, placeLocation, 8, 0.3, 0.3, 0.3, 0.05);
    }

    private void removeOneTNT(Player player) {
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() == Material.TNT && item.getAmount() > 0) {
            item.setAmount(item.getAmount() - 1);
            player.updateInventory();
        }
    }

    private void throwTNT(Player player) {
        Location eyeLoc = player.getEyeLocation();
        World world = player.getWorld();
        Location spawnLoc = eyeLoc.clone().add(eyeLoc.getDirection().multiply(0.5));
        TNTPrimed tnt = (TNTPrimed)world.spawn(spawnLoc, TNTPrimed.class);
        tnt.setFuseTicks(80);
        tnt.setSource((Entity)player);
        world.playSound(spawnLoc, Sound.ENTITY_SNOWBALL_THROW, 0.8f, 0.8f);
        Vector direction = eyeLoc.getDirection();
        Vector velocity = direction.clone().normalize().multiply(1.5);
        velocity.setY(velocity.getY() + 0.5);
        velocity.add(new Vector((Math.random() - 0.5) * 0.1, (Math.random() - 0.5) * 0.05, (Math.random() - 0.5) * 0.1));
        tnt.setVelocity(velocity);
        world.spawnParticle(Particle.CLOUD, spawnLoc, 6, 0.2, 0.2, 0.2, 0.02);
    }
}

